-- V2D - 56043 Messaging for Item Received Notification

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='TOOLS_AND_SERVICES');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'ITEM_RECEIVED_NOTIFICATION', 'Item Received Notification', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'ITEM_RECEIVED_NOTIFICATION');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'ITEM_RECEIVED_NOTIFICATION_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'ITEM_RECEIVED_NOTIFICATION_RECIPIENT', 'SQL');


SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ITEM_RECEIVED_NOTIFICATION_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'ITEM_RECEIVED_NOTIFICATION_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ITEM_RECEIVED_NOTIFICATION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ITEM_RECEIVED_NOTIFICATION_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the ITEM_RECEIVED_NOTIFICATION_DL list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ITEM_RECEIVED_NOTIFICATION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    id AS USER_ID
FROM
    fd_management_items
WHERE
    id IN (namedParams)",NULL);


-- Setting the query for the ITEM_RECEIVED_NOTIFICATION_RECIPIENT Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ITEM_RECEIVED_NOTIFICATION_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    T1.inwardNo AS INWARD_NO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    T4.inventoryType AS INVENTORY_TYPE,
    T7.printName AS ENTRY_BY_PRINT_NAME,
    T7.firstName AS ENTRY_BY_FIRST_NAME,
    T7.lastName AS ENTRY_BY_LAST_NAME,
    DATE_FORMAT(T1.acknowledgmentDate, '%d-%m-%Y') AS ACKNOWLEDGMENT_DATE,
	DATE_FORMAT(T1.deliveryDate, '%d-%m-%Y') AS DELIVERY_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    fd_management_items AS T1
        INNER JOIN
    users AS T2 ON T2.id = T1.receiverId
        INNER JOIN
    staffs T3 ON T3.userId = T2.id
        INNER JOIN
    persons p ON p.id = T3.personId
        LEFT JOIN
    invt_type_master T4 ON T4.id = T1.itemCategoryId
        LEFT JOIN
    staffs T5 ON T5.userId = T1.entryBy
        LEFT JOIN
    persons T7 ON T7.id = T5.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id
UNION
SELECT 
    T1.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    T1.inwardNo AS INWARD_NO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    T4.inventoryType AS INVENTORY_TYPE,
    T7.printName AS ENTRY_BY_PRINT_NAME,
    T7.firstName AS ENTRY_BY_FIRST_NAME,
    T7.lastName AS ENTRY_BY_LAST_NAME,
    DATE_FORMAT(T1.acknowledgmentDate, '%d-%m-%Y') AS ACKNOWLEDGMENT_DATE,
	DATE_FORMAT(T1.deliveryDate, '%d-%m-%Y') AS DELIVERY_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    fd_management_items AS T1
        INNER JOIN
    users AS T2 ON T2.id = T1.receiverId
        INNER JOIN
    students T3 ON T3.userId = T2.id
        INNER JOIN
    persons p ON p.id = T3.personId
        LEFT JOIN
    invt_type_master T4 ON T4.id = T1.itemCategoryId
        LEFT JOIN
    staffs T5 ON T5.userId = T1.entryBy
        LEFT JOIN
    persons T7 ON T7.id = T5.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "inwardNo",
            "resultKey": "INWARD_NO",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "inventoryType",
            "resultKey": "INVENTORY_TYPE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "printName",
            "resultKey": "ENTRY_BY_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "firstName",
            "resultKey": "ENTRY_BY_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "lastName",
            "resultKey": "ENTRY_BY_LAST_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "ACKNOWLEDGMENT_DATE",
            "resultKey": "ACKNOWLEDGMENT_DATE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "id",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "deliveryDate",
            "resultKey": "DELIVERY_DATE",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='ITEM_RECEIVED_NOTIFICATION');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='TOOLS_AND_SERVICES');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ITEM_RECEIVED_NOTIFICATION_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Item Received Notification',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Item Received Notification',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Item Received','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Your item $recipientData[&quot;INVENTORY_TYPE&quot;] of Inward No. $recipientData[&quot;INWARD_NO&quot;] has been received at front desk please collect and update the acknowledgment status.</span></span></p>  
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br />
  <strong>  $recipientData[&quot;ENTRY_BY_FIRST_NAME&quot;] $recipientData[&quot;ENTRY_BY_LAST_NAME&quot;] <br />        $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>          				
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.com/mailer/academiaerp-logo-red.png"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Item Received','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Your item $recipientData[&quot;INVENTORY_TYPE&quot;] of Inward No. $recipientData[&quot;INWARD_NO&quot;] has been received at front desk please collect and update the acknowledgment status.</span></span></p>  
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br />
  <strong>  $recipientData[&quot;ENTRY_BY_FIRST_NAME&quot;] $recipientData[&quot;ENTRY_BY_LAST_NAME&quot;] <br />        $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>          				
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.com/mailer/academiaerp-logo-red.png"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Your item $recipientData[&quot;INVENTORY_TYPE&quot;] of Inward No. $recipientData[&quot;INWARD_NO&quot;] has been received at front desk please collect and update the acknowledgment status.');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateconfigId+1,'6','Item Received','Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Your item $recipientData[&quot;INVENTORY_TYPE&quot;] of Inward No. $recipientData[&quot;INWARD_NO&quot;] has been received at front desk please collect and update the acknowledgment status.');




-- End Messaging for ITEM_RECEIVED_NOTIFICATION Event
